/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2540;

public class PlayerSoundPacket
extends SoundPacket<PlayerSoundPacket> {
    protected boolean whispering;
    protected float distance;

    public PlayerSoundPacket(UUID channelId, UUID sender, byte[] data, long sequenceNumber, boolean whispering, float distance, @Nullable String category) {
        super(channelId, sender, data, sequenceNumber, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket(UUID channelId, UUID sender, short[] data, boolean whispering, float distance, @Nullable String category) {
        super(channelId, sender, data, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket() {
    }

    @Override
    public UUID getSender() {
        return this.sender;
    }

    public boolean isWhispering() {
        return this.whispering;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public PlayerSoundPacket fromBytes(class_2540 buf) {
        PlayerSoundPacket soundPacket = new PlayerSoundPacket();
        soundPacket.channelId = buf.method_10790();
        soundPacket.sender = buf.method_10790();
        soundPacket.data = buf.method_10795();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        soundPacket.whispering = this.hasFlag(data, (byte)1);
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.method_10800(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10797(this.channelId);
        buf.method_10797(this.sender);
        buf.method_10813(this.data);
        buf.method_52974(this.sequenceNumber);
        buf.method_52941(this.distance);
        byte data = 0;
        if (this.whispering) {
            data = this.setFlag(data, (byte)1);
        }
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.method_52997((int)data);
        if (this.category != null) {
            buf.method_10788(this.category, 16);
        }
    }
}

